/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul;

import com.vinlanx.gunfireoverhaul.client.ClientSoundHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PlayTrackedSoundPacket {
    private final Vec3 pos;
    private final ResourceLocation soundId;
    private final float volume;
    private final float pitch;
    private final long delayTicks;
    private final boolean isPlayerInHouse;

    public PlayTrackedSoundPacket(Vec3 pos, ResourceLocation soundId, float volume, float pitch, long delayTicks, boolean isPlayerInHouse) {
        this.pos = pos;
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
        this.delayTicks = delayTicks;
        this.isPlayerInHouse = isPlayerInHouse;
    }

    public static void encode(PlayTrackedSoundPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.pos.f_82479_);
        buf.writeDouble(msg.pos.f_82480_);
        buf.writeDouble(msg.pos.f_82481_);
        buf.m_130085_(msg.soundId);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
        buf.m_130103_(msg.delayTicks);
        buf.writeBoolean(msg.isPlayerInHouse);
    }

    public static PlayTrackedSoundPacket decode(FriendlyByteBuf buf) {
        Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        ResourceLocation soundId = buf.m_130281_();
        float volume = buf.readFloat();
        float pitch = buf.readFloat();
        long delayTicks = buf.m_130258_();
        boolean isPlayerInHouse = buf.readBoolean();
        return new PlayTrackedSoundPacket(pos, soundId, volume, pitch, delayTicks, isPlayerInHouse);
    }

    public static void handle(PlayTrackedSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSoundHandler.addTrackedSound(msg)));
        ctx.get().setPacketHandled(true);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public ResourceLocation getSoundId() {
        return this.soundId;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getDelayTicks() {
        return this.delayTicks;
    }

    public boolean isPlayerInHouse() {
        return this.isPlayerInHouse;
    }
}

